float gbf(in vec3 eyePlayerPos, in float far)
{
    float distXZ = length((vec3(eyePlayerPos.x, 0.0, eyePlayerPos.z)).xyz);
    float distY = length((vec3(0.0, eyePlayerPos.y, 0.0)).xyz);
    float eyeDist = max(distXZ, distY);
#ifdef DISTANT_HORIZONS
    float borderFogFactor = smoothstep(dhRenderDistance * 0.9, dhRenderDistance, eyeDist);
    return borderFogFactor;
#else

    float borderFogFactor = smoothstep(far * 0.6, far, eyeDist);
    borderFogFactor *= borderFogFactor;

    return borderFogFactor;

#endif
}

void applySkyBlend2(inout vec4 toblend, vec3 sky, vec3 p3, float far)
{
#ifdef SKYBLEND

    float blend_factor = gbf(p3, far);

    toblend = mix(toblend, vec4(sky, 0.0), blend_factor * blend_factor);

#endif
}

vec3 fogAtmosphereALT2(
    vec3 D,
    float L,
    float L2,
    inout vec3 T,
    float B,
    float shadow,
    float depthshadow)
{
    // Constants
#ifdef VANILLA_SKY_COLOR
    vec3 SR = mix(pow(skyColor.rgb, vec3(3.0)) * 0.00003, vec3(2.901e-6, 6.779e-6, 1.655e-5), 0.0);
#else
    vec3 SR = vec3(2.901e-6, 6.779e-6, 1.655e-5);
#endif

    vec3 SM = vec3(7.992e-6);
    vec3 SL = vec3(10.448, 19.435, 37.188);
    vec3 TC = vec3(7.836e-6, 1.457625e-5, 2.7891e-5);

// Light properties
#ifdef DE
    const float LR = 0.001;
    const vec3 LP = vec3(0.0, 1.0, 0.0);
#elif defined DN
    const float LR = 0.5;
    const vec3 LP = vec3(0.0, 1.0, 0.0);
#else
    float LR = lightRadiance;
    vec3 LP = lightPos;
#endif
DD
    rayDir = normalize(rayDir);

    // PrecomputDstants
    float rdY = rayDir.y;
    float t2 = -6371000.0 * rdY + sqrt(4.0589641e13 * rdY * rdY + 1.2842e12);
D
    float CT = dot(rayDir, LP);
    float PR = 0.12 * (1.0 + CT * CT);
    float term = 1.7225 - 1.7 * CT;

    float OD_x = min(L, t2);
    float OD_y = min(L2, t2);

    float h = 1.0 - 1.0 / (2.0 + t2 * t2 * 9e-13);
    float h2 = h * h;
    float DR = h2;
    float DM = h2 * h2 * h * rainStrengthInv;
    float PM = 0.2775 / (12.5664 * sqrt(term) * term) * 0.5;

    float ti = clamp((LP.y - 1.0) * -0.7142857, 0.0, 1.0);
    float tSmooth = ti * ti * (3.0 - 2.0 * ti);
    float LPS = pow(tSmooth, 8.0) * h * SunsetMult;

    vec3 LC = LR * exp(-SL * LPS);

    // Exponentials
    vec3 e_SR = exp(-OD_x * DR * SR);
    vec3 e_SM = exp(-OD_x * DM * SM);

    // Scattering
    vec3 S = ((1.0 - e_SR) * PR * LC * shadow + (1.0 - e_SM) * PM * LC * shadow) * sunpow;
    T = exp(-OD_y * DR * TC);

#ifdef DO

    if (B > 0.0)
    {

        float density2 = B * 64.0 * 100000.0;

    #ifdef VSS
        LC *= clamp(pow(depthshadow, 32), 0, 1);
    #endif

        // 2nd sample (all the way to atmosphere exit), used for fog fade.
        vec3 R2 = (1.0 - exp(-t2 * DR * SR)) * PR * LC;
        vec3 M2 = (1.0 - exp(-t2 * DM * SM)) * PM * LC;
        vec3 S2 = (R2 + M2) * sunpow;
        vec3 T2 = exp(-t2 * DR * vec3(0.000007836, 0.00001457625, 0.000027891));

        /////
        float term = 1.85 - 1.70 * CT;

        float rayL3 = L + density2;
        float t2 = -6371000.0 * rdY + sqrt(4.0589641e13 * rdY * rdY + 1.2842e12);
        float PR = 0.12 * (1.0 + CT * CT);

        float OD_x = min(rayL3, t2);

        float h = 1.0 - 1.0 / (2.0 + t2 * t2 * 9e-13);
        float h2 = h * h;
        float DR = h2;
        float DM = h2 * h2 * h * rainStrengthInv; // h^5 * rainStrengthInv
        float PM = 0.2775 / (12.5664 * sqrt(term) * term) * 0.5;

        float ti = clamp((LP.y - 1.0) * -0.7142857, 0.0, 1.0); // Equivalent to (LP.y -1)/-1.4
        float tSmooth = ti * ti * (3.0 - 2.0 * ti);
        float LPS = pow(tSmooth, 8.0) * h * SunsetMult;

        vec3 LC = LR * exp(-SL * LPS);

        // Exponentials
        vec3 e_SR = exp(-OD_x * DR * SR);
        vec3 e_SM = exp(-OD_x * DM * SM);
        float shadows = mix(shadow, 1.0, 0.25);
        // Scattering
        S = ((1.0 - e_SR) * PR * LC * shadows + (1.0 - e_SM) * PM * LC * shadow * 1.0) * sunpow;
        S = mix(S, S2, B);

        T = exp(-OD_x * DR * TC);
        T = mix(T, T2, B);

        S *= mix(vec3(1.0, 0.9, 0.8), vec3(1.0), B);
    }

    S = mix(S, S + luma(S) * LC, clamp(sunElevation * 0.25, 0, 1));

    vec3 TS = S * 16.0 + 0.01;
    float DP = dot(TS, vec3( 0.299, 0.587, 0.114););
    float DP2 = dot(S, vec3( 0.299, 0.587, 0.114););

    vec3 RC = mix(vec3(0.4, 0.5, 0.6), vec3(0.016, 0.05, 0.066), 1.0 - nightblend5);
    vec3 RTC = mix(vec3(0.8, 0.85, 0.9), vec3(0.3, 0.34, 0.36), 1.0 - nightblend5);

    vec3 NC = vec3(0.04, 0.1, 0.11);
    S = mix(S, DP * NC, 1.0 - nightblend5);
    S = mix(S, DP2 * RC, rainStrength * nightblend5);
    T = mix(T, luma(T) * RTC, rainStrength * nightblend5);

#else

    #ifdef DE
    S *= 64.0;
    S = luma(S) * sunLight;
    T = exp(-OD_y * DR * (1.0 - vec3(0.184, 0.169, 0.212)) / 20000.0) + exp(-OD_y * DR * TC) * 0.2;

    if (B > 0.0)
    {
        #ifdef VL_SELF_SHADOWING
        LC *= clamp(pow(depthshadow, 64), 0, 1);
        #endif
        vec3 e_SR_t2 = exp(-t2 * DR * SR);
        vec3 e_SM_t2 = exp(-t2 * DR * SM);
        vec3 S2 = (0.5 * (1.0 - e_SR_t2) * PR * LC + (1.0 - e_SM_t2) * PM * LC) * sunpow;
        /////
D
        float rdY = rayDir.y;
        float t2 = rdY;

        float h = 1.0 - 1.0 / (2.0 + t2 * t2 * 9e-13);
        float h2 = h * h;
        float DR = h2;

        T = mix(T, exp(-t2 * DR * TC), B);

        S = mix(S, S + luma(S2) * vec3(1, 0.3, 0.2) * 2048, B);
    }

    #else
    T = vec3(T.x * T.y * T.z);
    S = luma(S) * sunLight * 0.5;
        #if defined(VOLUMETRIC_LIGHTING)

    if (B > 0.0)
    {
            #ifdef VSS
        LC *= clamp(pow(depthshadow, 1), 0, 1) * 4.0;
            #endif
        vec3 e_SR_t2 = exp(-t2 * DR * SR);
        vec3 e_SM_t2 = exp(-t2 * DR * SM);
        vec3 S2 = (0.5 * (1.0 - e_SR_t2) * PR * LC + (1.0 - e_SM_t2) * PM * LC) * sunpow;
        /////
D
        float rdY = rayDir.y;
        float t2 = rdY;

        float h = 1.0 - 1.0 / (2.0 + t2 * t2 * 9e-13);
        float h2 = h * h;
        float DR = h2;

        T = mix(T, exp(-t2 * DR * TC), clamp(B, 0, 1));

        S = mix(S, S + luma(S2) * vec3(1, 0.3, 0.12) * 16, clamp(B, 0, 1));
    }
        #else
    S = mix(S, S + luma(S) * vec3(1, 0.3, 0.12) * 16, 0.1);

        #endif
    #endif
#endif

    return S;
}